# fplot_deriv.R
# Plot a function and its derivative

# Load necessary libraries
library(ggplot2)

# Minimum and maximum values of x
xmin <- -5
xmax <- 5

# Divisions between xmin and xmax (more = smoother graph)
xdiv <- 100

# Step size
xstep <- (xmax-xmin)/xdiv

# Find x values for the plot
x <- seq(xmin,xmax,xstep)

# Insert y = f(x) and dy/dx formulas here
# Quadratic function
y <- -x^2 + 2*x + 5 
dydx <- -2*x + 2

# Make data frame for ggplot2
plotdata <- as.data.frame(cbind(x,y,dydx))

# Print data
plotdata

# Plot the values
ggplot(plotdata,aes(x,y))+
geom_line(color="red",size=1)+
geom_line(aes(x,dydx),color="blue",size=1)+
ggtitle("Plot a function and its derivative - quadratic function")
